package xerces;

/**
 * Title:        DOM Beispiele
 * Description:  Einfache Anwendung des DOM Modells
 * Copyright:    Copyright (c) 2001
 * Company:      http://www.joller-voss.ch
 * @author Josef M. Joller
 * @version 1.0
 */

import org.w3c.dom.*;
import org.apache.xerces.parsers.DOMParser;

class Noten
{
    static float noten[][] = new float[100][5];
    static int nstudent = 0;
    static int gi = -1;

    public static void berechneNoten(String uri)
	{
	    try {
		DOMParser parser = new DOMParser();
		parser.parse(uri);
		Document doc = parser.getDocument();
		traverse_tree(doc);
		berechneEndnoten();
	    } catch (Exception e) {
		e.printStackTrace(System.err);
	    }
	}

    private static void berechneEndnoten()
	{
	    float Ave = 0;
	    int i = 0, j = 0;
	    System.out.println("Noten");
	    for(i = 0; i < nstudent ; i++) {
	      float total = 0;
	      for(j = 0; j < 4; j++) {
		  total += noten[i][j];
	      }
	      noten[i][4] = total/4;
	      Ave += noten[i][4];
	      System.out.println("Student " + i + "=" + noten[i][4]);
	    }
	    Ave /= nstudent;
	    System.out.println("Klassenschnitt =" + Ave);
	}
    private static void traverse_tree(Node node)
	{
	    if(node == null) {
		return;
	    }
	    int type = node.getNodeType();
	    switch (type) {
	    case Node.DOCUMENT_NODE: {
		traverse_tree(((Document)node).getDocumentElement());
		break;
	    }
	    case Node.ELEMENT_NODE: {
		String elementName = node.getNodeName();
		gi = -1;
		if(elementName.equals("Pr1"))
		    gi = 0;
		else if(elementName.equals("Pr2"))
		    gi = 1;
		else if(elementName.equals("Projekt"))
		    gi = 2;
		else if(elementName.equals("Endnote"))
		    gi = 3;
		else if(elementName.equals("Student"))
		    nstudent++;

		NodeList childNodes = node.getChildNodes();
		if(childNodes != null) {
		    int length = childNodes.getLength();
		    for (int loopIndex = 0; loopIndex < length ; loopIndex++)
		    {
			traverse_tree(childNodes.item(loopIndex));
		    }
		}
		break;
	    }
	    case Node.TEXT_NODE: {
		String chData = node.getNodeValue().trim();
		if(chData.indexOf("\n") < 0 && chData.length() > 0) {
		    if(gi >= 0)
			noten[nstudent-1][gi] = Integer.parseInt(chData);
		}
	    }
	    }
	}
}

public class DOMNoten
{

    public static void main(String[] args)
	{
	    //Noten.berechneNoten(args[0]);
	    Noten.berechneNoten("Studenten.xml");
	}
}
