package xerces;

/**
 * Title:        DOM Beispiele
 * Description:  Einfache Anwendung des DOM Modells
 * @author Josef M. Joller
 * @version 1.0
 */

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DisplayElements {
	public static void displayDocument(String uri) {
		try {
			DOMParser parser = new DOMParser();
			parser.parse(uri);
			Document doc = parser.getDocument();
			display_names(doc);
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
	}

	public static void display_names(Node node) {
		if (node == null) {
			return;
		}
		int type = node.getNodeType();
		switch (type) {
			case Node.DOCUMENT_NODE :
				{
					display_names(((Document) node).getDocumentElement());
					break;
				}
			case Node.ELEMENT_NODE :
				{
					System.out.println("Element : " + node.getNodeName());

					NodeList childNodes = node.getChildNodes();
					if (childNodes != null) {
						int length = childNodes.getLength();
						for (int loopIndex = 0;
							loopIndex < length;
							loopIndex++) {
							display_names(childNodes.item(loopIndex));
						}
					}
					break;
				}
		}
	}
}

public class DOMNameElemente {

	public static void main(String[] args) {
		//DisplayElements.displayDocument(args[0]);
		DisplayElements.displayDocument("Studenten.xml");
	}
}
