package xerces;

/**
 * Title:        DOM Beispiele
 * Description:  Einfache Anwendung des DOM Modells
 * Copyright:    Copyright (c) 2001
 * Company:      http://www.joller-voss.ch
 * @author Josef M. Joller
 * @version 1.0
 */

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Figuren {
	public static void berechneFlaeche(String uri) {
		try {
			DOMParser parser = new DOMParser();
			parser.parse(uri);
			Document doc = parser.getDocument();
			traverse_tree(doc);
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
	}

	private static void traverse_tree(Node node) {
		if (node == null) {
			return;
		}
		int type = node.getNodeType();
		switch (type) {
			case Node.DOCUMENT_NODE :
				{
					traverse_tree(((Document) node).getDocumentElement());
					break;
				}
			case Node.ELEMENT_NODE :
				{
					String elementName = node.getNodeName();
					NamedNodeMap attrs = node.getAttributes();
					if (elementName.equals("Kreis")) {
						Attr attrib = (Attr) attrs.getNamedItem("r");
						String sr = attrib.getValue();
						float radius = Float.valueOf(sr).floatValue();
						float area = (float) Math.PI * radius * radius;
						System.out.println(
							"Kreis : \tRadius = "
								+ radius
								+ " Flaeche = "
								+ area);
					} else if (elementName.equals("Rechteck")) {
						Attr attrib = (Attr) attrs.getNamedItem("w");
						String sw = attrib.getValue();
						attrib = (Attr) attrs.getNamedItem("h");
						String sh = attrib.getValue();
						float width = Float.valueOf(sw).floatValue();
						float height = Float.valueOf(sh).floatValue();
						float area = width * height;
						System.out.println(
							"Rechteck : \tBreite = "
								+ width
								+ " Hoehe = "
								+ height
								+ " Flaeche = "
								+ area);
					} else if (elementName.equals("Ellipse")) {
						Attr attrib = (Attr) attrs.getNamedItem("w");
						String sw = attrib.getValue();
						attrib = (Attr) attrs.getNamedItem("h");
						String sh = attrib.getValue();
						float width = Float.valueOf(sw).floatValue();
						float height = Float.valueOf(sh).floatValue();
						float area =
							(float) Math.PI * (width / 2) * (height / 2);
						System.out.println(
							"Ellipse : \tBreite = "
								+ width
								+ " Hoehe = "
								+ height
								+ " Flaeche = "
								+ area);
					}
					NodeList childNodes = node.getChildNodes();
					if (childNodes != null) {
						int length = childNodes.getLength();
						for (int loopIndex = 0;
							loopIndex < length;
							loopIndex++) {
							traverse_tree(childNodes.item(loopIndex));
						}
					}
					break;
				}
		}
	}
}

public class DOMFlaechen {

	public static void main(String[] args) {
		//Figuren.berechneFlaeche(args[0]);
		Figuren.berechneFlaeche("Figuren.xml");
	}
}
