/*
 * Created on 21.02.2004
 * ValidierenderParser
 *
*/
package crimson;

/**
 * @author jjoller
 *
 */
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

public class ValidierenderParser {
	private static final String URL="adressbuch_02.xml";
	public static void main(String[] args) {
		String document;
		if (args.length <= 0) {
			System.out.println("Usage: java ValidierenderParser URL");
			//return;
			document = URL;
		} else document = args[0];

		try {
			DocumentBuilderFactory factory =
				DocumentBuilderFactory.newInstance();
			//Namespace
			factory.setNamespaceAware(true);
			//Validation
			factory.setValidating(true);

			DocumentBuilder parser = factory.newDocumentBuilder();

			//Error Handler
			ErrorHandlerBeispiel handler = new ErrorHandlerBeispiel();
			parser.setErrorHandler(handler);

			parser.parse(document);
			if (handler.isValid()) {
				System.out.println(document + " ist gltig.");
			} else {
				// falls nicht wohlgeformt: Exception wurde bereits geworfen
				System.out.println(document + " ist wohlgeformt.");
			}

		} catch (SAXException e) {
			System.out.println(document + " ist nicht wohlgeformt.");
		} catch (IOException e) {
			System.out.println(
				"IOException: es wurde keine berprfung durchgefhrt "
					+ document);
		} catch (FactoryConfigurationError e) {
			System.out.println("Die Factory Klasse wurde nicht gefunden");
		} catch (ParserConfigurationException e) {
			System.out.println("JAXP Parser wurde nicht gefunden");
		}
	}
}
