/*
 * Created on 22.02.2004
 * TransformerTest
 *
*/
package crimson;

/**
 * @author jjoller
 *
 */
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TransformerTest {
	private static String URL="adressbuch_02.xml";
	public static void main(String[] args) {
		String xml_doc;
		if (args.length <= 0) {
			System.out.println("Usage: java TransformerTest URL");
			//return;
			xml_doc = URL;
		} else {
			xml_doc = args[0];			
		}
		

		try {
			// Parser bestimmen
			DocumentBuilderFactory factory =
				DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			DocumentBuilder parser = factory.newDocumentBuilder();

			// Lesen des Dokuments
			Document document = parser.parse(xml_doc);

			// Modifizieren des Dokuments
			KnotenUmordnen.processNode(document);

			// Ausgabe
			TransformerFactory xformFactory = TransformerFactory.newInstance();
			Transformer idTransform = xformFactory.newTransformer();
			Source input = new DOMSource(document);
			Result output = new StreamResult(System.out);
			idTransform.transform(input, output);

		} catch (SAXException e) {
			System.out.println(xml_doc + " ist wohlgeformt.");
		} catch (IOException e) {
			System.out.println(
				"IOException beim Lesen von " + xml_doc);
		} catch (FactoryConfigurationError e) {
			System.out.println("Die Factory Klasse wurde nicht gefunden");
		} catch (ParserConfigurationException e) {
			System.out.println("Der JAXP Parser wurde nicht gefunden");
		} catch (TransformerConfigurationException e) {
			System.out.println("Dieser DOM Parser untersttzt 'transform' nicht.");
		} catch (TransformerException e) {
			System.out.println("Transform schlug fehl.");
		}
	}
}
