/*
 * Created on 21.02.2004
 * NodePropertiesText
 *
*/
package crimson;


/**
 * @author jjoller
 *
 */
import org.w3c.dom.*;
import java.io.*;


public class NodePropertiesText {

  private Writer out;
  
  public NodePropertiesText(Writer out) {
	if (out == null) {
	  throw new NullPointerException("Writer ist null.");
	}
	this.out = out;
  }
  
  public NodePropertiesText() {
	this(new OutputStreamWriter(System.out));
  }
  
  private int nodeCount = 0;
  
  public void writeNode(Node node) throws IOException {
    
	if (node == null) {
	  throw new NullPointerException("Node ist null.");
	}
	if (node.getNodeType() == Node.DOCUMENT_NODE 
	 || node.getNodeType() == Node.DOCUMENT_FRAGMENT_NODE) { 
	  // Neues Dokument : zurck setzen des Zhlers
	  nodeCount = 1; 
	}
    
	String name      = node.getNodeName();
	String type      = NodeInterfaceText.getTypeName(node);
	String localName = node.getLocalName();
	String uri       = node.getNamespaceURI();
	String prefix    = node.getPrefix();
	String value     = node.getNodeValue();
    
	StringBuffer result = new StringBuffer();
	result.append("Node " + nodeCount + ":\r\n");
	result.append("  Type: " + type + "\r\n");
	result.append("  Name: " + name + "\r\n");
	if (localName != null) {
	  result.append("  Local Name: " + localName + "\r\n");
	}
	if (prefix != null) {
	  result.append("  Prefix: " + prefix + "\r\n");
	}
	if (uri != null) {
	  result.append("  Namespace URI: " + uri + "\r\n");
	}
	if (value != null) {
	  result.append("  Value: " + value + "\r\n");
	}
    
	out.write(result.toString());
	out.write("\r\n");
	out.flush();
    
	nodeCount++; 
  }
}

