/*
 * Created on 21.02.2004
 * NodeInterfaceTextTest
 *
*/
package crimson;

/**
 * @author jjoller
 *
 */
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NodeInterfaceTextTest {
	private static final String URL = "adressbuch_02.xml";
	public static void main(String[] args) {
		String doc;
		if (args.length <= 0) {
			System.out.println("Usage: java NodeInterfaceTextTest URL");
			//return;
			doc = URL;
		} else {
			doc = args[0];
		}

		NodeInterfaceTextTest iterator = new NodeInterfaceTextTest();
		try {
			//JAXP sucht den Parser
			DocumentBuilderFactory factory =
				DocumentBuilderFactory.newInstance();
			// Namespace Support
			factory.setNamespaceAware(true);
			DocumentBuilder parser = factory.newDocumentBuilder();

			// einlesen des Dokuments
			Node document = parser.parse(doc);

			// DOM Baum analysieren, ab dem Root
			iterator.followNode(document);

		} catch (SAXException e) {
			System.out.println(doc + " ist nicht wohlgeformt.");
			System.out.println(e.getMessage());
		} catch (IOException e) {
			System.out.println(e);
		} catch (ParserConfigurationException e) {
			System.out.println("JAXP Parser wurde nicht gefunden");
		}
	} // end main
	private NodePropertiesText printer = new NodePropertiesText();
	// rekursive Traversierung
	public void followNode(Node node) throws IOException {
		printer.writeNode(node);
		if (node.hasChildNodes()) {
			Node firstChild = node.getFirstChild();
			followNode(firstChild);
		}
		Node nextNode = node.getNextSibling();
		if (nextNode != null)
			followNode(nextNode);
	}
	
	// Version mit NodeList
	public void followNode2(Node node) throws IOException {

		printer.writeNode(node);

		// Kind Knoten verarbeiten
		NodeList children = node.getChildNodes();
		for (int i = 0; i < children.getLength(); i++) {
			Node child = children.item(i);
			followNode(child); // Rekursion
		}
	}
}
