/*
 * Created on 22.02.2004
 * KnotenUmordnen
 *
*/
package crimson;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/**
 * @author jjoller
 *
 */

public class KnotenUmordnen {
	public static void processNode(Node current) throws DOMException {
		System.out.println("Node Name: "+current.getNodeName() +"; Node Value :"+current.getNodeValue());
		Node nextSibling = current.getNextSibling();

		int nodeType = current.getNodeType();
		if (nodeType == Node.COMMENT_NODE
			|| nodeType == Node.PROCESSING_INSTRUCTION_NODE) {

			Node document = current.getOwnerDocument();
			System.out.println("\tDocument Node: "+document.getNodeName() +"; Node Value :"+document.getNodeValue());
			Node root = document.getFirstChild();
			while (!(root.getNodeType() == Node.ELEMENT_NODE)) {
				root = root.getNextSibling();
			}

			Node parent = current.getParentNode();
			parent.removeChild(current);
			if (nodeType == Node.COMMENT_NODE) {
				document.appendChild(current);
			} else if (nodeType == Node.PROCESSING_INSTRUCTION_NODE) {
				document.insertBefore(current, root);
			}
		} else if (current.hasChildNodes()) {
			Node firstChild = current.getFirstChild();
			System.out.println("\tChild Node Name: "+current.getNodeName() +"; Child Node Value :"+current.getNodeValue());
			processNode(firstChild);
		}

		if (nextSibling != null) {
			processNode(nextSibling);
		}
	}
	
}
