/*
 * Created on 17.11.2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package crimson;

import java.io.IOException;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * @author jjoller
 *
 * Einfacher Error Handler fr JAXP
 */
public class ErrorHandlerBeispiel implements ErrorHandler {
	private boolean isValid=true;

	public void warning(SAXParseException se) {
		setValid(false);
		System.out.println("Warning: " + se.getMessage());
		System.out.println(
			" in Zeile "
				+ se.getLineNumber()
				+ ", Spalte "
				+ se.getColumnNumber());
		if (se.getSystemId() == null)
			System.out.println(" in Entity " + se.getSystemId());
	}

	public void error(SAXParseException se) {
		setValid(false);
		System.out.println("Error: " + se.getMessage());
		System.out.println(
			" in Zeile "
				+ se.getLineNumber()
				+ ", Spalte "
				+ se.getColumnNumber());
		if (se.getSystemId() == null)
			System.out.println(" in Entity " + se.getSystemId());
	}

	public void fatalError(SAXParseException se) {
		setValid(false);
		System.out.println("Fatal Error: " + se.getMessage());
		System.out.println(
			" in Zeile "
				+ se.getLineNumber()
				+ ", Spalte "
				+ se.getColumnNumber());
		if (se.getSystemId() == null)
			System.out.println(" in Entity " + se.getSystemId());
	}

	public static void main(String[] args) {
		System.setProperty(
			"org.xml.sax.driver",
			"org.apache.crimson.parser.XMLReaderImpl");

		String xml_doc = "Fehlerhaftes.xml";

		try {
			XMLReader parser = XMLReaderFactory.createXMLReader();
			ErrorHandler handler = new ErrorHandlerBeispiel();
			parser.setErrorHandler(handler);
			parser.parse(xml_doc);
			System.out.println(xml_doc + " ist wohlgeformt.");
		} catch (SAXParseException se) {
			System.out.print(xml_doc + " ist nicht wohlgeformt.");
			System.out.println(
				"Zeile "
					+ se.getLineNumber()
					+ ", Spalte "
					+ se.getColumnNumber());
			if (se.getSystemId() == null)
				System.out.println(" in Entity " + se.getSystemId());
		} catch (SAXException e) {
			System.out.println(
				"Genereller Fehler beim Parsen von "
					+ xml_doc
					+ " : "
					+ e.getMessage());
		} catch (IOException e) {
			System.out.println("IOException beim Lesen von " + xml_doc);
		}
	}

	/**
	 * @return
	 */
	public boolean isValid() {
		return isValid;
	}

	/**
	 * @param b
	 */
	public void setValid(boolean b) {
		isValid = b;
	}

}
