import java.net.*;
import java.io.*;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

/**
 * RMIServer dient als Server fr den remote "HalloService" Service.
 *
 * RMIServer startet beim Standard Entry Point "public static void main";
 * kreiert sich selbst und fhrt den Konstruktor aus.
 *
 */

public class RMIServer
{
   private static final int    PORT        = 10002;

//
// -> Change the name to your own computer name
//
   private static final String HOST_NAME   = "localhost";
   //private static final String HOST_NAME   = "ztnw293.hta.fhz.ch";


   // Instanzieren (sich selbst)
   private static RMIServer  rmi;

   public static void main ( String[] args )
   {
      // RMISecurityManager : Achtung! (java.policy Datei)
      //System.setSecurityManager( new RMISecurityManager() );

      try
      {
         rmi = new RMIServer();
      }
      catch ( java.rmi.UnknownHostException uhe )
      {
         System.out.println( "Der von Ihnen angegeben Hostrechner, " + HOST_NAME + " wurde nicht gefunden." );

      }
      catch ( RemoteException re )
      {
         System.out.println( "Fehler bein Starten des Service" );
         System.out.println( "" + re );
      }
      catch ( MalformedURLException mURLe )
      {
         System.out.println( "URL Fehler" + mURLe );
      }
      catch ( NotBoundException nbe )
      {
         System.out.println( "Service wurde nicht gebunden" );
         System.out.println( "" + nbe );
      }

   }  


   // Konstruktor
   public RMIServer() throws RemoteException, MalformedURLException, NotBoundException
   {
      LocateRegistry.createRegistry( PORT );

      System.out.println( "Registry wurde af dem Host " + HOST_NAME + " an Port " + Integer.toString( PORT) +" kreiert!");

      Hallo h = new HalloImpl();

      System.out.println( "Remote HalloService Implementationsobjekt kreiert" );

      String urlString = "rmi://" + HOST_NAME + ":" + Integer.toString( PORT ) + "/" + "HalloService";

      Naming.rebind( urlString, h );

      System.out.println( "Der Service ist gebunden; er wartet nun auf Kundenanfragen." );
   }

}  
