import java.net.*;
import java.io.*;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

/**
 * RMIClient benutzt das remote "Hallo" Objekt.
 *
 * RMIClient benutzt Parameter des RMI Server 
 */

public class RMIClient
{
   private static final int    PORT        = 10002;
//
// -> hier knnen Sie Ihren Rechner angeben
//
//   private static final String HOST_NAME   = "localhost";
   private static final String HOST_NAME   = "ztnw293.hta.fhz.ch";

   // Instanzieren (sich selbst)
   private static RMIClient  rmi;

   // Instanz der Root Objekt(e)
   private static Hallo  hallo;

   public static void main ( String[] args )
   {

      rmi = new RMIClient();

   }  



   // Konstruktor
   public RMIClient()
   {

      Hallo h;
      String halloString;
      MessageObjekt mo;

      try
      {
         h = (Hallo)Naming.lookup( "rmi://" + HOST_NAME + ":" + Integer.toString( PORT ) + "/HalloService" );

         System.out.println( "HalloService Lookup erfolgreich" );

         halloString = h.sagHallo();

         System.out.println( "Antwort des Servers: " + halloString );


         for ( int i = 0; i< 10; i++ )
         {
            mo = h.herunterladenMessageObjekt();
            System.out.println( "MessageObjekt: Nummer (Klassenvariable) ist " + mo.abfragenNummerDerKlasse() + "; die Objekt Nummer ist " +  mo.abfragenNummerDesObjekts() );
         }

      }
      catch ( java.rmi.UnknownHostException uhe )
      {
         System.out.println( "Der von Ihnen angegebene Host, " + HOST_NAME + " wurde nicht gefunden." );
      }
      catch ( RemoteException re )
      {
         System.out.println( "Eine Remote Exception wurde geworfen, als der HalloService aufgerufen wurde" );
         System.out.println( "" + re );
      }
      catch ( MalformedURLException mURLe )
      {
         System.out.println( "Die rmi URL ist nicht korrekt" );
         System.out.println( "" + mURLe );
      }
      catch ( NotBoundException nbe )
      {
         System.out.println( "Das Server Objekt ist nicht gebunden " + nbe );
      }

   }

} 
