import java.net.*;
import java.io.*;
import java.util.Date;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

/**
 * RMIServer dient als Server fr den "ZeitServer" Service.
 *
 * RMIServer startet als "public static void main";
 * instanziert sich selbst und fhrt den Konstruktor aus.
 *
 */

public class RMIServer implements Remote, ZeitServer
{
   private static final int    PORT        = 10005;

//
// -> Namen anpassen
//
   private static final String HOST_NAME   = "localhost";
   //private static final String HOST_NAME   = "ztnw293.hta.fhz.ch";
   //private static final String HOST_NAME   = "ztnw293.ztl.ch";
   //private static final String HOST_NAME   = "client-88-96.highspeed.ch";


   // Instanzieren (sich selbst)
   private static RMIServer  rmi;

   public static void main ( String[] args )
   {
      // RMISecurityManager: bedingt java.policy
      //System.setSecurityManager( new RMISecurityManager() );
      System.out.println("RMIServer: Start");

      try
      {
         rmi = new RMIServer();

         LocateRegistry.createRegistry( PORT );
         System.out.println( "RMIServer: Registry kreiert" );

         UnicastRemoteObject.exportObject( ((ZeitServer)rmi) );

         Naming.rebind( "rmi://" + HOST_NAME + ":" + Integer.toString( PORT ) + "/" + "ZeitServer", rmi );
         System.out.println( "RMIServer: Objektbindung abgeschlossen" );
         System.out.println( "RMIServer: Warten auf Kundenanfragen" );
      }
      catch ( java.rmi.UnknownHostException uhe )
      {
         System.out.println( "RMIServer: Der Rechner " + HOST_NAME + " wurde nicht gefunden: der Name ist falsch." );

      }
      catch ( RemoteException re )
      {
         System.out.println( "RMIServer: Fehler beim Starten des Service" );
         System.out.println( "" + re );
      }
      catch ( MalformedURLException mURLe )
      {
         System.out.println( "RMIServer: URL Fehler " + mURLe );
      }

   }  // main

   public void registrierenZeitMonitor( ZeitMonitor zm )
   {
      System.out.println( "RMIServer: Kundenanfrage liegt vor!" );

      // ZeitTicker wird unten definiert!
      ZeitTicker zt;

      // Definition des Registrierens
      // 1. ZeitTicker Objekt kreieren
      // 2. Starten des Objekts
       // Ihre Programmcode:

      System.out.println( "RMIServer: Timer gestartet" );
   }


}  // class RMIServer

class ZeitTicker extends Thread
{

   private ZeitMonitor zm;

   ZeitTicker( ZeitMonitor zm )
   {
     System.out.println("RMIServer: Thread ZeitTicker Konstruktor");
      this.zm = zm;
   }

   public void run()
   {
      System.out.println("RMIServer: Thread ZeitTicker run()");
      while ( true )
      {
         try
         {
            sleep( 2000 );
            System.out.println("RMIServer: Thread ZeitTicker Zeit:"+new Date());
            // Ihr Programmcode : eine Zeile

         }
         catch ( Exception e )
         {
            System.out.println("RMIServer: Thread ZeitTicker stop()");
            stop();
         }
      }
   }
}