import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.Date;
import java.net.URL;
import java.rmi.*;
import java.rmi.server.*;

public class RMIApplet extends Applet implements ZeitMonitor
{
   // passen Sie diese Variable gegebenenfalls an:
   private final static String HOST_NAME = "localhost";

   private ZeitServer zs;

   public void init()
   {
      super.init();

      uiInit(); // wird unten definiert

      try
      {
         System.out.println( "RMIApplet: Export des Applet" );
         UnicastRemoteObject.exportObject( this );
         URL     base = getDocumentBase();

         String hostName = base.getHost();
         System.out.println( "RMIApplet: Hostname "+hostName );
         System.out.println( "RMIApplet: DocumentBase "+base );

         if ( 0 == hostName.length() )
         {
            hostName = HOST_NAME;
         }

         String  serverName = "rmi://" + hostName + ":" + getParameter( "registryPort" ) + "/ZeitServer" ;
         System.out.println( "RMIApplet: Lookup ZeitService auf dem Server: " + serverName );

         try
         {
            zs = (ZeitServer)Naming.lookup( serverName );
         }
         catch ( Exception e )
         {
            System.out.println( "RMIApplet: Fehler beim Lookup: " + e );
         }
         zs.registrierenZeitMonitor( this );
         System.out.println( "RMIApplet: Der Zeit Monitor wurde registriert!" );
      }
      catch ( RemoteException re )
      {
         System.out.println( "RMIApplet: Remote Exception: " + re );
      }
	}

   public void sagMirDieZeit( Date d )
   {
      System.out.println( "RMIApplet: sagMirDieZeit() " + d );
      textArea1.appendText( d.toString() + "\n" );
   }


   public void uiInit()
   {
      setLayout(null);
      resize(456,266);
      textArea1 = new java.awt.TextArea();
      textArea1.reshape(36,24,252,170);
      add(textArea1);

      button1 = new java.awt.Button("Clear");
      button1.reshape(324,36,72,24);
      add(button1);

      button1.addActionListener
      (
         new ActionListener()
         {

            public void actionPerformed(ActionEvent event)
            {
               textArea1.setText("");
            }
         }
      );



   }

   java.awt.TextArea textArea1;
   java.awt.Button button1;
}
