/**
 * Class:        RemoteModelMgrImpl
 *
 * Einsatz:      Liefert eine Implementation fr den RemoteModelMgr
 *               RMI Service.
 *
 * Bemerkungen:  RemoteModel ist ein RMI "Remote" interface.
 *               LocalModel ist ein lokales Interface
 */
public class RemoteModelMgrImpl extends java.rmi.server.UnicastRemoteObject
                                implements RemoteModelMgr {
   LocalModel      lm;
   RemoteModelImpl rmImpl;

   /**
    * Konstruktor
   */
   public RemoteModelMgrImpl() throws java.rmi.RemoteException {
      super();
   }

   public RemoteModelRef getRemoteModelRef() throws java.rmi.RemoteException {
      // Lazy Instanzierung des Delegierten
      if ( null == lm ) {
         lm = new LocalModel();
      }

      // Lazy Instanzierung des Remote Interface Wrapper
      if ( null == rmImpl ) {
         rmImpl = new RemoteModelImpl( lm );
      }

      return ( (RemoteModelRef) rmImpl );
   }


   /**
    * Liefere eine Referenz auf das Objekt welches die
    * echten Operationen liefert. Falls dies ein RMI Call ist,
    * wird eine Kopie zurck geliefert.
   */
   public LocalModel getLocalModel() throws java.rmi.RemoteException  {
      // Lazy Instanzierung des Delegierten
      if ( null == lm ) {
         lm = new LocalModel();
      }
      return lm;
   }
}
