/**
 * Class:        LocalRemoteServer
 *
 * Einsatz:      Instanziert und registriert die Remote Services
 *
 */
import java.net.*;
import java.io.*;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

public class LocalRemoteServer
{
   private static final int    PORT        = 10009;
   //
   // -> passen Sie diese Zeile Ihrer Umgebung an
   //
   private static final String HOST_NAME   = "localhost";


   // Instanzierung des Servers
   private static LocalRemoteServer lrs;

   public static void main (String[] args)  {
      // RMISecurityManager
      System.setSecurityManager( new RMISecurityManager() );

      try {
         lrs = new LocalRemoteServer();
      } catch ( java.rmi.UnknownHostException uhe )  {
         System.out.println( "Der Host, den Sie angegeben haben " + HOST_NAME + " stimmt nicht mit der Umgebung ueberein." );
      }  catch ( RemoteException re ) {
         System.out.println( "RemoteException: Fehler beim Starten des Services" );
         System.out.println( "" + re );
      }  catch ( MalformedURLException mURLe ) {
         System.out.println( "Interner Fehler: URL " + mURLe );
      } catch ( NotBoundException nbe ) {
         System.out.println( "Der Service ist nicht gebunden" );
         System.out.println( "" + nbe );
      }
   }
   // Konstruktor
   public LocalRemoteServer() throws RemoteException, MalformedURLException,
                                     NotBoundException   {
      LocateRegistry.createRegistry( PORT );
      System.out.println( "Registry wurde auf dem Host " + HOST_NAME + " an Port " + Integer.toString( PORT) +" kreiert." );

      RemoteModelMgrImpl rmmImpl = new RemoteModelMgrImpl();
      System.out.println( "RemoteModelImpl Objekt kreiert." );

      String urlString = "//" + HOST_NAME + ":" + Integer.toString( PORT ) + "/" + "RemoteModelManager";

      Naming.rebind( urlString, rmmImpl );
      System.out.println( "RemoteModel wurde gebunden." );
      System.out.println( "Warten auf Kundenanfragen ..." );
   }
}

