/**
 * Class:        LocalRemoteClient
 *
 * Einsatz:      Testen des Delegation Pattern um
 *               Remote und lokale Versionen
 *               eines RMI Netzwerk Services zu implementieren.
 */
import java.net.*;
import java.io.*;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

public class LocalRemoteClient {
   private static final int    PORT        = 10009;
   //
   // -> Anpassen
   //
   private static final String HOST_NAME   = "localhost";

   // Instanzierung
   private static LocalRemoteClient lrc;

   public static void main  (String[] args ){
      lrc = new LocalRemoteClient();
   }
   // Konstruktor
   public LocalRemoteClient()   {
      RemoteModelMgr rmm;

      LocalModel     lm;
      RemoteModelRef rmr;

      String         versionLocal;
      String         versionRemote;

      try  {
         rmm = (RemoteModelMgr)Naming.lookup( "rmi://" + HOST_NAME + ":" + Integer.toString( PORT ) + "/RemoteModelManager" );
         System.out.println( "RemoteModelManager Lookup erfolgreich" );

         rmr           = rmm.getRemoteModelRef();
         versionRemote = rmr.getVersionNumber();
         System.out.println( "Remote Version: " + versionRemote );

         lm            = rmm.getLocalModel();
         System.out.println( "Lokale Version des geladenen Modells" );

         versionLocal  = lm.getVersionNumber();
         System.out.println( "Lokale Version: " + versionLocal  );
      }  catch ( java.rmi.UnknownHostException uhe ){
         System.out.println( "Ihre Angaben zum Host " + HOST_NAME + " sind nicht korrekt." );
      }  catch ( RemoteException re ){
         System.out.println( "Remote Exception: RemoteModelManager Server" );
         System.out.println( "" + re );
      }  catch ( MalformedURLException mURLe ) {
         System.out.println( "Problem mit rmi: URL Fehler" );
         System.out.println( "" + mURLe );
      }  catch ( NotBoundException nbe ) {
         System.out.println( "" + nbe );
      }  catch ( Exception e )  {
         System.out.println( "" + e );
      }
   }
}
