import java.rmi.*;
import java.net.MalformedURLException;
import java.util.Locale;
import java.text.NumberFormat;

public class BankKunde {

  // Interface Referenz auf de BankkontoManager
  private BankkontoManager bm;

  // Standard Konstruktor
  public BankKunde() {

    try {
      bm = (BankkontoManager)Naming.lookup("rmi://localhost:1099/BankSystem");
    } catch (MalformedURLException malformedException) {
      System.err.println("URL Fehler: " + malformedException);
    } catch (NotBoundException notBoundException) {
      System.err.println("Remote Objekt ist nicht gebunden: " + notBoundException);
    } catch (RemoteException remoteException) {
      System.err.println("Remote Exception: " + remoteException);
    }

    try {
      // Lookup Konto 4461
      // Ihr Aufruf

      // Kunde fr Konto
      // Ihr Aufruf

      // Name des Kunden
      // Ihr Aufruf

      // Kontostand
      // Ihr Aufruf

      // Formatieren und anzeigen der Ausgabe fr USD (US Dollar)
      NumberFormat whrungsFormat = NumberFormat.getCurrencyInstance(Locale.US);
      String kontostandString = whrungsFormat.format(cash);
      System.out.println("Kontostand in USD:");
      System.out.println("Auf "+name + "'s Konto befinden sich " + kontostandString);

      // Formatieren und anzeigen der Ausgabe fr CHF (Schweizer Franken)
      Locale loc = new Locale("de","CH"); // Sprache, Lndercode [ISO]
      whrungsFormat = NumberFormat.getCurrencyInstance(loc);
      float fWechselkurs = 1.58f;		// ... oder was auch immer
      System.out.println("Kontostand in CHF bei einem Wechselkurs von "+fWechselkurs+" :");
      kontostandString = whrungsFormat.format(cash*fWechselkurs);
      System.out.println("Auf "+name + "'s Konto befinden sich " + kontostandString);
    } catch (RemoteException remoteException) {
      System.err.println(remoteException);
    }
  }

  public static void main(String[] args) {
    new BankKunde();
  }
}
