import java.util.Date;
import java.net.MalformedURLException;

import java.rmi.*;

/**
 * RMIClient ruft den "Hallo" Service auf.
 *
 * Bei vielen Aufrufen wird der
 * Distributed Garbage Collector und die lokalen GCs eingesetzt.
 *
 */

public class RMIClient {
   private static final int    PORT        = 10007;

//
// -> hier mssen Sie den Programmcode anpassen
//
   private static final String HOST_NAME   = "localhost";


   // Instanzieren
   private static RMIClient  rmi;

   public static void main ( String[] args ) {
      rmi = new RMIClient();
   }  // main


   // Konstruktor
   public RMIClient() {
      try {
         Hallo hallo = (Hallo)Naming.lookup( "//" + HOST_NAME + ":" + Integer.toString( PORT ) + "/" + "Hallo" );
         System.out.println( "HalloService lookup erfolgreich" );
         System.out.println( "Message vom Server: " + hallo.sagHallo() );

         MessageObjekt mo;

         for ( int i = 0; i< 1000; i++ ) {
            mo = hallo.holeDasMessageObjekt();
            System.out.println( "MessageObjekt: Klasse-Nummer ist #" + mo.liesDieNummerVonDerKlasse() + " Objekt Nummer ist #" +  mo.liesDieNummerVonDerKlasse() );
            mo = null;
         }
      } catch ( java.rmi.UnknownHostException uhe ){
         System.out.println( "Der Hostrechner " + HOST_NAME + " stimmt nicht mit dem gefundenen ueberein." );
      } catch ( RemoteException re ) {
         System.out.println( "Remote Exception: beim Aufrufen des Service" );
         System.out.println( "" + re );
      } catch ( MalformedURLException mURLe ) {
         System.out.println( "Problem mit rmi: URL Fehler" );
         System.out.println( "" + mURLe );
      } catch ( NotBoundException nbe ) {
         System.out.println( "Service nicht gebunden " + nbe );
      }
   }
}

