import java.net.*;
import java.io.*;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

/**
 * RMIServer ist der Server fr den "Hallo" Service.
 *
 * RMIServer startet bei "public static void main";
 * dann kreiert er eine Instanz seiner selbst
 * und setzt die Verarbeitung im Konstruktor fort.
 */

public class RMIServer {
   private static final int    PORT        = 10007;

//
// -> hier mssen Sie Ihren Rechner angeben
//
   private static final String HOST_NAME   = "localhost";


   // Instanz bilden
   private static RMIServer  rmi;

   public static void main ( String[] args ) {
      // RMISecurityManager
      System.setSecurityManager( new RMISecurityManager() );

      try {
         rmi = new RMIServer();
      } catch ( java.rmi.UnknownHostException uhe ){
         System.out.println( "Der Hostname " + HOST_NAME + " entspricht nicht der Realitaet." );
      } catch ( RemoteException re ) {
         System.out.println( "Fehler beim Starten des Service" );
         System.out.println( "" + re );
      } catch ( MalformedURLException mURLe ) {
         System.out.println( "Interner Fehler: URL " + mURLe );
      } catch ( NotBoundException nbe ) {
         System.out.println( "Service ist nicht gebunden" );
         System.out.println( "" + nbe );
      }
   }


   // Konstruktor
   public RMIServer() throws RemoteException, MalformedURLException,
                NotBoundException  {
      LocateRegistry.createRegistry( PORT );

      System.out.println( "Registry wurde auf dem Host Computer " + HOST_NAME +
                        " an Port " + Integer.toString( PORT)+ " exportiert" );
      Hallo hallo = new HalloImpl();
      System.out.println( "Remote Hallo Service Implementationsobjekt kreiert" );

      String urlString = "//" + HOST_NAME + ":" + Integer.toString( PORT ) +
                         "/" + "Hallo";

      Naming.rebind( urlString, hallo );

      System.out.println( "Binden abgeschlossen, warten auf Client Anfragen." );
   }
}


