package RMIClientLoader;

import java.net.*;
import java.io.*;
import java.util.Properties;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

/**
 * RMIClientLoader wird benutzt, um einen RMI Client zu "Bootstrap".
 * Die Client Klasse und alle untersttzenden Klassen werden ber RMI
 * mit Hilfe des HTTP Servers geladen
 *
 */

public class RMIClientLoader {
  private static final int    PORT        = 10009;
  private static String HOST_NAME   = "localhost";

  // referenzieren von sich selbst
  private static RMIClientLoader rcl;

  // Bootstrapper
  private Class    clientClass;
  private Runnable client;

  private URL        url;
  private Properties p;

  // Befehlsplatzhalter
  private String clientName;

  // Konstruktor
  public RMIClientLoader() throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
	System.out.println("RMIClientLoader: Konstruktor");
        try {
	  System.out.println("RMIClientLoader: System.getProperties()");
	  p = System.getProperties();

          // zum Testen
	  Properties pro = new Properties();
	  pro = System.getProperties();
	  //pro.list(System.out);
	  String urlString = pro.getProperty("java.rmi.server.codebase");
	  System.out.println("RMIClientLoader: Abfrage java.rmi.server.codebase="+urlString);

	  url = new URL(p.getProperty("java.rmi.server.codebase"));
    	  System.out.println("RMIClientLoader: URL Konstruktor - java.rmi.server.codebase=" + url);

    	  // Informationen aus den Properties knnen von allen gelesen werden
    	  System.out.println("RMIClientLoader: Setzen von java.rmi.server.rminode = "+"rmi://" + HOST_NAME + ":" + Integer.toString(PORT) + "/");
    	  p.put("java.rmi.server.rminode",  "rmi://" + HOST_NAME + ":" + Integer.toString(PORT) + "/");
       } catch(java.lang.Exception ex) {
          System.out.println("Fehler beim Bestimmen der Properties");
          System.out.println(""+ex.getMessage());
        }

    	// Mit Hilfe des RMIClassLoader werden die Client Klassen geladen, aus der obigen URL
    	//clientName = "RMIClient";
    	clientName = "RMIClient";

        System.out.println("RMIClientLoader: Abfrage der Registry");
        try {
      	  int il=Naming.list("rmi://" + HOST_NAME).length;
          System.out.println("RMIClientLoader: Anzahl Eintraege="+il);
	  System.out.println("RMIClientLoader: Eintraege in der Registry");
	  for (int i=0; i< Naming.list("rmi://" + HOST_NAME +  ":" + Integer.toString( PORT ) + "/" ).length; i++)
		System.out.println("                "+Naming.list("rmi://"+HOST_NAME+ ":" + Integer.toString( PORT ) + "/" )[i]);
        } catch (java.rmi.ConnectException ce) {
          //System.out.println("java.rmi.ConnectException Ausnahme wurde bei der Registry Abfrage geworfen \n"+ce.getMessage());
          //System.out.println("");
          //ce.printStackTrace();
          System.out.println("RMIClientLoader: Abfrage der Registry ist nicht moeglich");
        } catch (java.rmi.RemoteException re) {
          //System.out.println("java.rmi.RemoteException Ausnahme wurde bei der Registry Abfrage geworfen");
          //re.printStackTrace();
          System.out.println("RMIClientLoader: Abfrage der Registry ist nicht moeglich");
        }

    	System.out.println("RMIClientLoader: Anfrage fuer: " + url + " und " + clientName);
    	clientClass = RMIClassLoader.loadClass(url, clientName);
    	System.out.println("RMIClientLoader: Client Klassen sind geladen");
        System.out.println("RMIClientLoader: Name der Client Klasse : "+clientClass.getName());

    	// kreieren einer neuen Instanz der Client Klasse
    	client = (Runnable)clientClass.newInstance();

    	// Start des Client Programms : "run" Methode.
    	System.out.println("RMIClientLoader: Client starten - run()");
    	client.run();
  }

  public static void main (String args[]) {
	System.out.println("RMIClientLoader: Start");
	//System.out.println("RMIClientLoader: RMIClientBootstrapSecurityManager()");
    	//System.setSecurityManager( new RMIClientBootstrapSecurityManager());
	System.out.println("RMIClientLoader: RMISecurityManager()");
    	System.setSecurityManager( new RMISecurityManager());
	if (args.length >= 1) {
            	HOST_NAME = args[0];
            }

    	try {
		System.out.println("RMIClientLoader: Instanzierung des RMIClientLoaders");
      		rcl = new RMIClientLoader();
    	} catch (MalformedURLException mURLe) {
      		System.out.println("RMIClientLoader: URL Angabe fuer die Client Klassen ist nicht korrekt: " + mURLe);
    	} catch (ClassNotFoundException cnfe) {
      		System.out.println("RMIClientLoader: Klassen werden nicht gefunden: " + cnfe);
    	} catch (InstantiationException ie) {
      		System.out.println( "RMIClientLoader: Klasse konnte nicht instanziert werden " + ie);
    	} catch (IllegalAccessException iae) {
      		System.out.println("RMIClientLoader: interner Fehler - IllegalAccessException" + iae);
    	}
   }
}
