package RMIClientLoader;

import java.rmi.RMISecurityManager;

/**
 * Diese Klasse definiert die Zugriffsrechte, Security Policy, fr RMI Applikationen,
 * die vom Server geladen werden.
 * Die Reduktion der Sicherheit im Vergleich zum Standard ist gering.
 *
 * Policies versus RMISecurityManager:
 *
 * Security Check                    	 Policy  	RMISecurityManager
 * ------------------------------   	------------  	------------------
 * Access to Thread Groups               	YES              NO
 * Access to Threads                     	YES              NO
 * Create Class Loader                   	YES              NO
 * System Properties Access              	YES              NO
 * Connections                           	YES              NO
 *
 */

public class RMIClientBootstrapSecurityManager  extends RMISecurityManager {

  /**
   * Geladene Klassen knnen ClassLoader kreieren
   */
  public synchronized void checkCreateClassLoader() {
    // null
	System.out.println("RMIClientBootstrapSecurityManager: checkCreateClassLoader()");
  }

  /**
   * Verbindungsaufbau zu andern Servern ist erlaubt.
   */
  public synchronized void checkConnect(String host, int port) {
	// null berschreibt
	System.out.println("RMIClientBootstrapSecurityManager: checkConnect()");
  }

  /**
   * Geladene Klassen drfen Threads manipulieren.
   */
  public synchronized void checkAccess(Thread t) {
    // null
	System.out.println("RMIClientBootstrapSecurityManager: checkAccess(Thread)");
  }

  /**
   * Geladene Klassen drfen Thread Gruppen manipulieren.
   */
  public synchronized void checkAccess(ThreadGroup g) {
    // null
	System.out.println("RMIClientBootstrapSecurityManager: checkAccess(ThreadGroup)");
  }

  /**
   * Geladene Klassen knnen auf die Systemeigenschaft-Tabelle zugreifen.
   */
  public synchronized void checkPropertiesAccess() {
    // null
	System.out.println("RMIClientBootstrapSecurityManager: checkPropertiesAccess()");
  }
}
