import java.net.*;
import java.io.*;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;

/**
 * RMIServer implementiert einen einfachen remote "Hallo" service.
 *
 * RMIServer startet mit  "public static void main";
 * kreiert eine Instanz seiner selbst und fhrt den Konstruktor aus
 *
 */

public class RMIServer
    {
    private static final int    PORT        = 10009;

    //
    // -> Anpassen: Ihr Rechner
    //
    //private static final String HOST_NAME   = "localhost";
    private static String HOST_NAME   = "localhost";


    // Selbst-Instanzierung
    private static RMIServer  rmi;

    public static void main ( String[] args )
	{
	System.out.println("RMIServer: Start");

        if (args.length >= 1)
        {
            HOST_NAME = args[0];
        }


	// RMISecurityManager
	System.out.println("RMIServer: RMISecurityManager");
	//System.setSecurityManager( new RMIServerSecurityManager() );
	System.setSecurityManager(new RMISecurityManager());

	try
	    {
	    rmi = new RMIServer();
	    System.out.println("RMIServer: Instanzierung des RMIServers");
	    }
	catch ( java.rmi.UnknownHostException uhe )
	    {
	    System.out.println("RMIServer: Die Hostangabe, " +  HOST_NAME +  " stimmt nicht."  );
	    }
	catch ( RemoteException re )
	    {
	    System.out.println( "RMIServer: Fehler beim Starten des Service" );
	    System.out.println( "" + re );
	    }
	catch ( MalformedURLException mURLe )
	    {
	    System.out.println( "RMIServer: Interner Fehler (URL)" + mURLe );
	    }
	catch ( NotBoundException nbe )
	    {
	    System.out.println( "RMIServer: Service ist nicht gebunden" );
	    System.out.println( "" + nbe );
	    }

	}

    // Konstruktor
    public RMIServer()
	throws RemoteException,
	MalformedURLException,
	NotBoundException
    {
	System.out.println("RMIServer: Konstruktor");
	System.out.println("RMIServer: Konstruktor - Kreieren der Registry fuer Port "+PORT);

	LocateRegistry.createRegistry( PORT );
	System.out.println( "RMIServer: Registry wurde auf dem Host "+HOST_NAME+" an Port "+ Integer.toString( PORT)+" kreiert!"  );

	System.out.println("RMIServer: Konstruktor - Instanzierung von HalloImpl");
	Hallo hallo  = new HalloImpl();

	System.out.println( "RMIServer: Remote Hallo Implementationsobjekt kreiert" );

	String urlString = "rmi://" + HOST_NAME +  ":" + Integer.toString( PORT ) + "/" +  "Hallo";

	// binden der Instanz an die Registry
	Naming.rebind(urlString,hallo);
	System.out.println("RMIServer: Hallo Server ist gebunden!");

	System.out.println("RMIServer: Abfrage der Registry");
	// zum Testen : Abfrage der Registry
	System.out.println("RMIServer: urlString="+urlString);
	int il=Naming.list(urlString).length; System.out.println("RMIServer: Laenge="+il);
	for (int i=0; i< Naming.list("rmi://" + HOST_NAME +  ":" + Integer.toString( PORT ) + "/" ).length; i++)
		System.out.println("           "+Naming.list("rmi://"+HOST_NAME+ ":" + Integer.toString( PORT ) + "/" )[i]);

	System.out.println("RMIServer: Binding an Server "+urlString+" abgeschlossen;" );
	System.out.println("RMIServer: warten auf Kundenanfragen." );
        // zum Testen
	System.out.println("RMIServer: System.getProperties()");
	Properties pro = new Properties();
	pro = System.getProperties();
	//pro.list(System.out);
 	String strCodebase = pro.getProperty("java.rmi.server.codebase");
	System.out.println("RMIServer: Abfrage java.rmi.server.codebase="+strCodebase);
      } //
    }

/**
 * Diese Klasse definiert die Zugriffsrechte, Security Policy, fr RMI Applikationen,
 * die vom Server geladen werden.
 * Die Reduktion der Sicherheit im Vergleich zum Standard ist gering.
 *
 * Policies versus RMISecurityManager:
 *
 * Security Check                    	This Policy  	RMISecurityManager
 * ------------------------------   	------------  	------------------
 * Access to Thread Groups               	YES              NO
 * Access to Threads                     	YES              NO
 * Create Class Loader                   	YES              NO
 * System Properties Access              	YES              NO
 * Connections                           	YES              NO
 *
 */

class RMIServerSecurityManager  extends RMISecurityManager
    {

    /**
     * Loaded classes are allowed to create class loaders.
     */
    public synchronized void checkCreateClassLoader()
	{
	// Provide null override
	System.out.println( "RMIServer: RMIServerSecurityManager.checkCreateClassLoader()");
	}


    /**
     * Connections to other machines are allowed
     */
    public synchronized void checkConnect( String host, int port )
	{
	// Provide null override
	System.out.println( "RMIServer: RMIServerSecurityManager.checkConnect()");
	}

    /**
     * Loaded classes are allowed to manipulate threads.
     */
    public synchronized void checkAccess(Thread t)
	{
	// Provide null override
	System.out.println( "RMIServer: RMIServerSecurityManager.checkAccess(Thread)");
	}

    /**
     * Loaded classes are allowed to manipulate thread groups.
     */
    public synchronized void checkAccess(ThreadGroup g)
	{
	// Provide null override
	System.out.println( "RMIServer: RMIServerSecurityManager.checkAccess(ThreadGroup)");
	}


    /**
     * Loaded classes are allowed to access the system properties list.
     */
    public synchronized void checkPropertiesAccess()
	{
	// Provide null override
	System.out.println( "RMIServer: RMIServerSecurityManager.checkPropertiesAccess()");
	}

    }