import java.net.*;
import java.io.*;
import java.util.Properties;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;

/**
 * RMIClient ist gebootstraptes RMI Client Programm.
 *
 * Es implementiert das Runnable Interface, damit es leicht gestartet werden kann.
 *
 */

public class RMIClient

implements Runnable
{
   // Instanz des Root Objekt(s)
   private Hallo         hallo;

   private String        rmiName;
   private Properties    p;
   private MessageObjekt mo;

   public void run()
   {
	System.out.println("RMIClient: run()");
      try
      {
         // Abfrage der Netzwerklokation des RMIServer
         // und Speichern in der System-Eigenschaftstabelle
         // .
         p       = System.getProperties();
         rmiName = (String)p.get( "java.rmi.server.rminode" );
         System.out.println( "RMIClient: java.rmi.server.rminode= " + rmiName );
         hallo   = (Hallo)Naming.lookup( rmiName + "Hallo" );

         System.out.println( "RMIClient: Message vom Server: " + hallo.sagHallo() );

         for ( int i = 0; i< 10; i++ )
         {
            mo = hallo.herunterladenMessageObjekt();
            System.out.println( "RMIClient: MessageObjekt: Klassenvariable Nummer " + mo.abfragenNummerDerKlasse() + " Objekt Number is " +  mo.abfragenNummerDesObjekts() );
         }
      }
      catch ( Exception e )
      {
         System.out.println( "RMIClient: es ist ein Fehler beim lokalisieren des Hallo Servers aufgetreten " + e );
         e.printStackTrace();
      }
   }

} 