package einfachercommandprozessorfuer_minisql;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) J.M.Joller
 * Company:      Joller-Voss GmbH
 * @author J.M.Joller
 * @version 1.0
 */

import java.net.URL;
import java.sql.*;
import com.imaginary.sql.msql.*;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class QueryApp {
    static Connection connection;

    static public void main(String args[]) {
	java.io.InputStreamReader reader;
	java.io.BufferedReader input;
	Properties props = new Properties();
	boolean connected = false;
	String buffer = "", url, driver;
        String uid="", pwd="";
	int line = 1; // aktuelle Eingabezeile

	// UserID, Passwort (dummy)
        try {
          if (args[0].equalsIgnoreCase("")) args[0]="borg";
          if (args[1].equalsIgnoreCase("")) args[1]="";
          uid = args[0];
          pwd = args[1];
        } catch(Exception e) { }
        if( args.length < 2 ) {
	    System.out.println("Syntax: <java QueryApp [user] [password]>");
	    //return;
            uid = "Hallo";
            pwd="miniSQL";
        }
	props.put("user",     uid);
	props.put("password", pwd);
	if( args.length > 2 ) {
	    url = args[2];
	}
	else {
	    url = "jdbc:msql://localhost:1112/db_bank";
	}
	if( args.length > 3 ) {
	    driver = args[3];
	}
	else {
	    driver = "com.imaginary.sql.msql.MsqlDriver";
	}
	// Connect
	try {
	    Class.forName(driver);
	    connection = DriverManager.getConnection(url, props);
	}
	catch( SQLException e ) {
	    System.out.println("Connect schlug fehl: " +
			       e.getMessage());
	    return;
	}
	catch( ClassNotFoundException e ) {
	    System.out.println("Driver Klasse wurde nicht gefunden.");
	    return;
	}
	System.out.println("Mit der DBMS verbunden.");
	connected = true;
	reader = new java.io.InputStreamReader(System.in);
	input = new java.io.BufferedReader(reader);
	//
	while( connected ) {
	    String tmp, cmd;

	    // Print Prompt
	    if( line == 1 ) {
		System.out.print(" > ");
	    }
	    else {
		System.out.print(line + "> ");
	    }
	    System.out.flush();
	    // nchste Inputzeile
	    try {
		tmp = input.readLine();
	    }
	    catch( java.io.IOException e ) {
		return;
	    }
	    // Leerzeichen lschen
	    cmd = tmp.trim();
	    // Transaktion abschliessen
	    if( cmd.equals("commit") ) {
		try {
		    connection.commit();
		    System.out.println("Commit erfolgreich.");
		}
		catch( SQLException e ) {
		    System.out.println("Error in commit(): " + e.getMessage());
		}
		buffer = "";
		line = 1;
	    }
	    // AUsfhren des Buffers
	    else if( cmd.equals("go") ) {
		if( !buffer.equals("") ) {
		    try {
			executeStatement(buffer, connection);
		    }
		    catch( SQLException e ) {
			System.out.println(e.getMessage());
		    }
		}
		buffer = "";
		line = 1;
		continue;
	    }
	    // Abschluss
	    else if( cmd.equals("quit") ) {
		connected = false;
		continue;
	    }
	    // Clear Buffer
	    else if( cmd.equals("reset") ) {
		buffer = "";
		line = 1;
		continue;
	    }
	    // Rollback Transaktion
	    else if( cmd.equals("rollback") ) {
		try {
		    connection.rollback();
		    System.out.println("Rollback erfolgreich.");
		}
		catch( SQLException e ) {
		    System.out.println("Ein Fehler trat beim rollback auf: " +
				       e.getMessage());
		}
		buffer = "";
		line = 1;
	    }
	    // Versionsinfo
	    else if( cmd.startsWith("show") ) {
		if( cmd.length() < 6 ) { //
		    System.out.println("show version");
		}
		else {
		    DatabaseMetaData meta;

		    try {
			meta = connection.getMetaData();
			cmd = cmd.substring(5, cmd.length()).trim();
			if( cmd.equals("version") ) {
			    showVersion(meta);
			}
			else {
			    System.out.println("show version"); // Bad arg
			}
		    }
		    catch( SQLException e ) {
			System.out.println("Fehler beim Laden der Metadaten: " +
					   e.getMessage());
		    }
		}
		buffer = "";
		line = 1;
	    }
	    //
	    else {
		buffer = buffer + " " + tmp;
		line++;
		continue;
	    }
	}
	try {
	    connection.close();
	}
	catch( SQLException e ) {
	    System.out.println("Error close() Connection: " + e.getMessage());
	}
	System.out.println("Connection closed.");
    }

    static public Vector executeSQL(String sql) {
	Vector v = new Vector();

	try {
	    Statement statement = connection.createStatement();

	    if( statement.execute(sql) ) {
		ResultSet results = statement.getResultSet();
		ResultSetMetaData meta = results.getMetaData();
		int cols;

		cols = meta.getColumnCount();
		while( results.next() ) {
		    Hashtable h = new Hashtable(cols);
		    int i;

		    for(i=0; i<cols; i++) {
			Object ob = results.getObject(i);

			h.put(meta.getColumnLabel(i), ob);
		    }
		    v.addElement(h);
		}
		return v;
	    }
	    return null;
	}
	catch( SQLException e ) {
	    e.printStackTrace();
	    return null;
	}
    }

    static public void executeStatement(String sql, Connection connection)
    throws SQLException {
	Statement statement = null;

	try {
	    statement = connection.createStatement();
	    if( statement.execute(sql) ) { // true: SQL war ein SELECT
		processResults(statement.getResultSet());
	    }
	    else { //
		int num;

		switch(num = statement.getUpdateCount()) {
		case 0:
		    System.out.println("Keine Mutationen.");
		    break;

		case 1:
		    System.out.println(num + " Zeile wurden mutiert.");
		    break;

		default:
		    System.out.println(num + " Zeilen wurden mutiert.");
		}
	    }
	}
	catch( SQLException e ) {
	    throw e;
	}
	finally { //
	    if( statement != null ) {
		try { statement.close(); }
		catch( SQLException e ) { }
	    }
	}
    }

    static public void processResults(ResultSet results) throws SQLException {
	try {
	    ResultSetMetaData meta = results.getMetaData();
	    StringBuffer bar = new StringBuffer();
	    String buffer = "";
	    int cols = meta.getColumnCount();
	    int row_count = 0;
	    int i, width = 0;

	    // Header fr Spalten
	    //
	    //  --------------------------------------
	    //  |    Column One    |   Column Two    |
	    //  --------------------------------------
	    //  |    Row 1 Value   |   Row 1 Value   |
	    //  --------------------------------------

	    // Trennzeile
	    for(i=1; i<=cols; i++) {
		width += meta.getColumnDisplaySize(i);
	    }
	    width += 1 + cols;
	    for(i=0; i<width; i++) {
		bar.append('-');
	    }
	    bar.append('\n');
	    buffer += bar + "|";
	    // Spaltenlabel
	    for(i=1; i<=cols; i++) {
		StringBuffer filler = new StringBuffer();
		String label = meta.getColumnLabel(i);
		int size = meta.getColumnDisplaySize(i);
		int x;

		// Breite der Spalte?
		if( label.length() > size ) {
		    label = label.substring(0, size);
		}
		if( label.length() < size ) {
		    int j;

		    x = (size-label.length())/2;
		    for(j=0; j<x; j++) {
			filler.append(' ');
		    }
		    label = filler + label + filler;
		    if( label.length() > size ) {
			label = label.substring(0, size);
		    }
		    else {
			while( label.length() < size ) {
			    label += " ";
			}
		    }
		}
		buffer = buffer + label + "|";
	    }
	    buffer = buffer + "\n" + bar;
	    while( results.next() ) {
		row_count++;

		buffer += "|";
		for(i=1; i<=cols; i++) {
		    StringBuffer filler = new StringBuffer();
		    Object value = results.getObject(i);
		    int size = meta.getColumnDisplaySize(i);
		    String str = value.toString();

		    if( str.length() > size ) {
			str = str.substring(0, size);
		    }
		    if( str.length() < size ) {
			int j, x;

			x = (size-str.length())/2;
			for(j=0; j<x; j++) {
			    filler.append(' ');
			}
			str = filler + str + filler;
			if( str.length() > size ) {
			    str = str.substring(0, size);
			}
			else {
			    while( str.length() < size ) {
				str += " ";
			    }
			}
		    }
		    buffer = buffer + str + "|";
		}
		buffer = buffer + "\n";
	    }
	    if( row_count == 0 ) {
		buffer = "Keine Zeile selektiert.\n" + buffer;
	    }
	    else if( row_count == 1 ) {
		buffer = "1 Zeile selektiert.\n" + buffer;
	    }
	    else {
		buffer = row_count + " Zeilen selektiert.\n" + buffer;
	    }
	    System.out.print(buffer);
	    System.out.flush();
	}
	catch( SQLException e ) {
	    throw e;
	}
	finally {
	    try { results.close(); }
	    catch( SQLException e ) { }
	}
    }

    static public void showVersion(DatabaseMetaData meta) {
	String version = "QueryApp 1.0\n";

	try {
	    version += "DBMS: " + meta.getDatabaseProductName() + " " +
		meta.getDatabaseProductVersion() + "\n";
	    version += "JDBC Driver: " + meta.getDriverName() + " " +
		meta.getDriverVersion();
	    System.out.println(version);
	}
	catch( SQLException e ) {
	    System.out.println("Versionsnummer konnte nicht bestimmt werden: " +e.getMessage());
	}
    }
}
