package apachesoap;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;

public class WieGehtsClient {

  public static void main(String[] args) throws Exception {

	String strURL=args[0];
	System.out.println("[WieGehtsClient]URL: "+strURL);
    URL url = new URL (strURL);//"http://localhost:8080/soap/servlet/rpcrouter");

    // Call Aufbau.
    Call call = new Call();
    call.setTargetObjectURI("urn:wiegehts");
    call.setMethodName("wiegehts");
    call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);

    Vector params = new Vector();
    String name="Hans";
    params.addElement(new Parameter("name", String.class, name, null));
    call.setParams (params);

    Response resp = call.invoke(url, "" );

    // Antwort Analyse.
    if ( resp.generatedFault() ) {

      Fault fault = resp.getFault ();
      System.out.println("Fehlerhafter Call: ");
      System.out.println("Fault Code   = " + fault.getFaultCode());
      System.out.println("Fault String = " + fault.getFaultString());
    }
    else {

      Parameter result = resp.getReturnValue();
      System.out.println(result.getValue());
    }
  }
}

